/*----------------------------------------------------------------------------
 * Name     : ht8.c
 * Purpose  : 
 * Note(s)  : 
 *----------------------------------------------------------------------------*/

#include		"ht8.h"

/*------------------------------------------------------------------------------
* Function Name : SystemClockConfigure
* Description   : setup MCU clock source
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void SystemClockConfigure(void)
{   
   _wdtc = 0x57;	
	_pbs1 |= 0xFC;				/* PB5=RESET,PB6=OSC1,PB7=OSC2 */
	_pfs1 |= 0x0F;				/* PF4=XT2,PF5=XT1 
	_rstc = 0xAA;				/* PB5 to RESET PIN */
	_hirc0 = LOW;	
	_hirc1 = LOW;
    _hircen= HIGH;              /* HIRC enable */
	_lxten = HIGH;				/* LXT enable */
	while(!_lxtf);				/* wait LXT stable */
	while(!_hircf);				/* wait HXT stable */	
	/* High Frequency clock = HXT (FHS=1) */	
	/* Low Frequency clock = LXT (FSS=1)*/
	/* High Frequency oscillator control enable(FHIDEN=1) */
	/* Low Frequency oscillator control enable (FSIDEN=1) */
	/* system clock = FH */


#if (SYSTEM_CLOCK == FSYS4MHZ)	/* for 4MHZ */
	_hirc0 = LOW;						/* HIRC=8MHZ */
	_hirc1 = LOW;						
	while(!_hircf);
	_scc = 0x25;						/* system clock = HIRC */
	_nop();
	_nop();
	_hxten = LOW;						/* HXT disable */	
#endif	


#if (SYSTEM_CLOCK == FSYS8MHZ)	/* for 8MHZ */
	_hirc0 = LOW;						/* HIRC=8MHZ */
	_hirc1 = LOW;
	while(!_hircf);
	_scc = 0x05;						/* system clock = HIRC */
	_nop();
	_nop();
	_hxten = LOW;						/* HXT disable */	
#endif	
	
	
#if (SYSTEM_CLOCK == FSYS12MHZ)	/* for 12MHZ */
	_hirc0 = HIGH;						/* HIRC=12MHZ */
	_hirc1 = LOW;
	while(!_hircf);
	_scc = 0x05;						/* system clock = HIRC */
	_nop();
	_nop();
	_hxten = LOW;						/* HXT disable */	
#endif		

#if (SYSTEM_CLOCK == FSYS16MHZ)	/* for 16MHZ */
	_hirc0 = LOW;						/* HIRC=16MHZ */
	_hirc1 = HIGH;						
	while(!_hircf);
	_scc = 0x05;						/* system clock = HIRC */
	_nop();
	_nop();
	_hxten = LOW;						/* HXT disable */	
#endif		
}
/*------------------------------------------------------------------------------
* Function Name : SysTick2msConfigure
* Description   : setup system tick 2ms(Time Base 0)
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/ 
void SysTick2msConfigure(void)
{
	_psc0r = 0x01;
	_tb0c = (SYSTEM_CLOCK + 0x03);
	_tb0f = FALSE;
	_tb0e = TRUE;
	_tb0on = TRUE;
}
/*------------------------------------------------------------------------------
* Function Name : DelayX10us
* Description   : delay X*10us(unit 10us)
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/ 
void	DelayX10us(u8 cnt)
{
	while(cnt)
	{	
#if (SYSTEM_CLOCK == FSYS16MHZ)					/* for 16MHZ */
		asm volatile("mov	a,8");
#elif (SYSTEM_CLOCK == FSYS12MHZ)				/* for 12MHZ */
		asm volatile("mov	a,6");
#elif (SYSTEM_CLOCK == FSYS8MHZ)					/* for 8MHZ */    
		asm volatile("mov	a,4");
#else
		asm volatile("mov	a,2");					/* for 4MHZ */
#endif         	
		asm volatile("nop");		
		asm volatile("sdz	acc");
		asm volatile("jmp $-2");
		cnt--;
	}
}
/*------------------------------------------------------------------------------
* Function Name : DelayXmSec
* Description   : delay X*250us(unit 250us)
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/ 
void DelayXmSec(u8 xs)
{
   while(xs)
   {
#if (SYSTEM_CLOCK == FSYS16MHZ) 					/* for 16MHZ */
		asm("mov		A,248");   	
#elif (SYSTEM_CLOCK == FSYS12MHZ) 				/* for 12MHZ */
		asm("mov		A,186");
#elif (SYSTEM_CLOCK == FSYS8MHZ)					/* for 8MHZ */    
		asm("mov		A,124");
#else
		asm("mov		A,61");							/* for 4MHZ */
#endif         	
      asm("clr wdt");
      asm("sdz acc");
      asm("jmp $-2");
      xs--;
   }
}
